{ $HDR$}
{**********************************************************************}
{ Unit archived using Team Coherence                                   }
{ Team Coherence is Copyright 2002 by Quality Software Components      }
{                                                                      }
{ For further information / comments, visit our WEB site at            }
{ http://www.TeamCoherence.com                                         }
{**********************************************************************}
{}
{ $Log:  11936: IdException.pas
{
    Rev 1.15    11/4/2003 10:26:58 PM  DSiders
  Added exceptions moved from IdIOHandler.pas and IdTCPConnection.pas.
}
{
{   Rev 1.14    2003.10.16 11:24:00 AM  czhower
{ Added IfAssigned
}
{
{   Rev 1.13    2003.10.11 5:47:58 PM  czhower
{ -VCL fixes for servers
{ -Chain suport for servers (Super core)
{ -Scheduler upgrades
{ -Full yarn support
}
{
{   Rev 1.12    10/3/2003 11:38:36 PM  GGrieve
{ Add EIdWrapperException
}
{
{   Rev 1.11    9/29/2003 02:56:28 PM  JPMugaas
{ Added comment about why IdException.Create is virtual.
}
{
{   Rev 1.10    9/24/2003 11:42:50 PM  JPMugaas
{ Minor changes to help compile under NET
}
{
{   Rev 1.9    2003.09.19 10:10:02 PM  czhower
{ IfTrue, IfFalse
}
{
{   Rev 1.8    2003.09.19 11:54:28 AM  czhower
{ -Completed more features necessary for servers
{ -Fixed some bugs
}
{
{   Rev 1.7    2003.07.17 4:57:04 PM  czhower
{ Added new exception type so it can be added to debugger list of ignored
{ exceptions.
}
{
    Rev 1.6    7/1/2003 8:33:02 PM  BGooijen
  Added EIdFibersNotSupported
}
{
{   Rev 1.5    2003.06.05 10:08:50 AM  czhower
{ Extended reply mechanisms to the exception handling. Only base and RFC
{ completed, handing off to J Peter.
}
{
    Rev 1.4    5/14/2003 2:59:58 PM  BGooijen
  Added exception for transparant proxy
}
{
{   Rev 1.3    2003.04.14 10:54:06 AM  czhower
{ Fiber specific exceptions
}
{
    Rev 1.2    4/2/2003 7:18:38 PM  BGooijen
  Added EIdHttpProxyError
}
{
{   Rev 1.1    1/17/2003 05:06:46 PM  JPMugaas
{ Exceptions for scheduler string.
}
{
{   Rev 1.0    11/13/2002 08:44:10 AM  JPMugaas
}
unit IdException;

interface

uses
  SysUtils;

type
  EIdException = class(Exception)
  public
  {
  The constructor must be virtual for Delphi NET if you want to call it with class methods.
  Otherwise, it will not compile in that IDE. Also it's overloaded so that it doesn't close
  the other methods declared by the DotNet exception (particularly InnerException constructors)
  }
    constructor Create(
      AMsg: string
      ); overload; virtual;
    class procedure IfAssigned(
      const ACheck: TObject;
      const AMsg: string = ''
      );
    class procedure IfFalse(
      const ACheck: Boolean;
      const AMsg: string = ''
      );
    class procedure IfNotAssigned(
      const ACheck: TObject;
      const AMsg: string = ''
      );
    class procedure IfNotInRange(
      const AValue: Integer;
      const AMin: Integer;
      const AMax: Integer;
      const AMsg: string = ''
      );
    class procedure IfTrue(
      const ACheck: Boolean;
      const AMsg: string = ''
      );
    class procedure Toss(
      const AMsg: string
      );
  end;
  TClassIdException = class of EIdException;

  // You can add EIdSilentException to the list of ignored exceptions to reduce debugger "trapping"
  // of "normal" exceptions
  EIdSilentException = class(EIdException);
  // EIdConnClosedGracefully is raised when remote side closes connection normally
  EIdConnClosedGracefully = class(EIdSilentException);

  // IdFiber Exceptions
  EIdFiber = class(EIdException);
  EIdFiberFinished = class(EIdFiber);
  EIdFibersNotSupported = class(EIdFiber);

  EIdAlreadyConnected = class(EIdException);

  // EIdClosedSocket is raised if .Disconnect has been called and an operation is attempted
  // or Connect has not been called
  EIdClosedSocket = class(EIdException);
  EIdResponseError = class(EIdException);
  EIdReadTimeout = class(EIdException);
  EIdReadLnMaxLineLengthExceeded = class(EIdException);

  // TIdTCPConnection exceptions
  EIdTCPConnectionError = class(EIdException);
  EIdObjectTypeNotSupported = class(EIdTCPConnectionError);
  EIdInterceptPropIsNil = class(EIdTCPConnectionError);
  EIdInterceptPropInvalid = class(EIdTCPConnectionError);
  EIdIOHandlerPropInvalid = class(EIdTCPConnectionError);
  EIdNoDataToRead = class(EIdTCPConnectionError);
  EIdFileNotFound = class(EIdTCPConnectionError);

  EIdNotConnected = class(EIdException);

  EIdInvalidServiceName = class(EIdException);

  EInvalidSyslogMessage = class(EIdException);
  EIdSSLProtocolReplyError = class(EIdException);
  EIdConnectTimeout = class(EIdException);
  EIdConnectException = class(EIdException);

  EIdTransparentProxyCantBind = class(EIdException);

  EIdHttpProxyError = class(EIdException);

  EIdSocksError = class(EIdException);
  EIdSocksRequestFailed = class(EIdSocksError);
  EIdSocksRequestServerFailed = class(EIdSocksError);
  EIdSocksRequestIdentFailed = class(EIdSocksError);
  EIdSocksUnknownError = class(EIdSocksError);
  EIdSocksServerRespondError = class(EIdSocksError);
  EIdSocksAuthMethodError = class(EIdSocksError);
  EIdSocksAuthError = class(EIdSocksError);
  EIdSocksServerGeneralError = class(EIdSocksError);
  EIdSocksServerPermissionError = class (EIdSocksError);
  EIdSocksServerNetUnreachableError = class (EIdSocksError);
  EIdSocksServerHostUnreachableError = class (EIdSocksError);
  EIdSocksServerConnectionRefusedError = class (EIdSocksError);
  EIdSocksServerTTLExpiredError = class (EIdSocksError);
  EIdSocksServerCommandError = class (EIdSocksError);
  EIdSocksServerAddressError = class (EIdSocksError);

  //IdIMAP4 Exception
  EIdConnectionStateError = class(EIdException);

  // THE EDnsResolverError is used so the resolver can repond to only resolver execeptions.
  EIdDnsResolverError = Class(EIdException);

  // This class used in DotNet. Under windows/linux, all errors that come out the
  // indy layer descend from IdException (actually not all errors in theory, but
  // certainly all errors in practice)
  // With DotNet, the socket library itself may raise various exceptions. If the
  // exception is a socket exception, then Indy will map this to an EIdSocketError.
  // Otherwise Indy will raise an EIdWrapperException. In this case, the original
  // exception will be available using the InnerException member
  EIdWrapperException = class (EIdException);

  {Socket exceptions}
  EIdInvalidSocket = class(EIdException);

  EIdSocketError = class(EIdException)
  private
    FLastError: Integer;
  public
    // Params must be in this order to avoid conflict with CreateHelp
    // constructor in CBuilder
    constructor CreateError(const AErr: Integer; const AMsg: string); virtual;
    //
    property LastError: Integer read FLastError;
  end;
  EIdNotASocket = class(EIdSocketError);

  EIdThreadMgrError = class(EIdException);
  EIdThreadClassNotSpecified = class(EIdThreadMgrError);

  {TIdTrivial FTP Exception }
  EIdTFTPException               = class(EIdException);
  EIdTFTPFileNotFound            = class(EIdTFTPException);
  EIdTFTPAccessViolation         = class(EIdTFTPException);
  EIdTFTPAllocationExceeded      = class(EIdTFTPException);
  EIdTFTPIllegalOperation        = class(EIdTFTPException);
  EIdTFTPUnknownTransferID       = class(EIdTFTPException);
  EIdTFTPFileAlreadyExists       = class(EIdTFTPException);
  EIdTFTPNoSuchUser              = class(EIdTFTPException);
  EIdTFTPOptionNegotiationFailed = class(EIdTFTPException);  // RFC 1782

  {Icmp exceptions}
  EIdIcmpException = class(EIdException);

  EIdSetSizeExceeded = class(EIdException);

  {IdMessage and things use this}
  EIdMessageException = class(EIdException);

  EIdBlockingNotSupported = class(EIdException);

  { resolving hostnames }
  EIdResolveError = class(EIdSocketError);
  EIdReverseResolveError = class(EIdSocketError);
  //scheduler exception
  EIdSchedulerException = class(EIdException);
  EIdSchedulerMaxThreadsExceeded = class(EIdSchedulerException);
implementation

constructor EIdSocketError.CreateError(const AErr: Integer; const AMsg: string);
begin
  inherited Create(AMsg);
  FLastError := AErr;
end;

{ EIdException }

constructor EIdException.Create(AMsg : String);
begin
  inherited Create(AMsg);
end;

class procedure EIdException.IfAssigned(const ACheck: TObject;
  const AMsg: string);
begin
  if ACheck <> nil then begin
    Toss(AMsg);
  end;
end;

class procedure EIdException.IfFalse(const ACheck: Boolean; const AMsg: string);
begin
  if not ACheck then begin
    Toss(AMsg);
  end;
end;

class procedure EIdException.IfNotAssigned(const ACheck: TObject;
  const AMsg: string);
begin
  if ACheck = nil then begin
    Toss(AMsg);
  end;
end;

class procedure EIdException.IfNotInRange(
  const AValue: Integer;
  const AMin: Integer;
  const AMax: Integer;
  const AMsg: string = ''
  );
begin
  if (AValue < AMin) or (AValue > AMax) then begin
    Toss(AMsg);
  end;
end;

class procedure EIdException.IfTrue(const ACheck: Boolean; const AMsg: string);
begin
  if ACheck then begin
    Toss(AMsg);
  end;
end;

class procedure EIdException.Toss(const AMsg: string);
begin
  raise Create(AMsg);
end;

end.
